<?php

namespace VM\ApiBundle\Controller;

use Doctrine\DBAL\LockMode;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations\View;
use VM\ApiBundle\Entity\Company;
use VM\ApiBundle\Entity\CompanyOffer;
use VM\ApiBundle\Entity\Offer;
use VM\ApiBundle\Entity\OfferReport;
use VM\ApiBundle\Entity\Round;
use VM\ApiBundle\Exceptions\ApiException;


class OffersController extends AbstractController
{
    /**
     * @View(serializerGroups={"offersDetails"})
     */
    public function getAction()
    {
        $User = $this->getUser();
        $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
        $Round = $this->getApiGetter()->getUserActualRound($User);
        $companyOffersInRound = $Company->getRoundOffers()->filter(function(CompanyOffer $OfferReport) use ($Round) {return $OfferReport->getRoundId() == $Round->getId();});

        $boughtIds = array();
        foreach($companyOffersInRound as $OfferReport)
        {
            $boughtIds[] = $OfferReport->getOfferId();
        }
        $boughtIds = array_merge($boughtIds,$this->getOffersOnlyOne($Company));

        $availableOffers = $this->getDoctrine()->getRepository('VMApiBundle:Offer')->getAvailbleOffers();

        return array(
            'availableOffers' => $availableOffers,
            'boughtIds' => $boughtIds,
        );
    }

    /**
     * @View()
     */
    public function saveAction()
    {
        $this->getDoctrine()->getConnection()->beginTransaction();
        try
        {
            $data = $this->getRequest()->request->getIterator()->getArrayCopy();

            $User = $this->getUser();
            $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
            $Round = $this->getApiGetter()->getUserActualRound($User);
            $CurrentAccount = $this->getApiGetter()->getCompanyCurrentAccount($Company->getId());

            $this->getDoctrine()->getManager()->lock($CurrentAccount, LockMode::OPTIMISTIC, $CurrentAccount->getVersion());

            $Offer = $this->getApiGetter()->getOffer($data['id']);

            if($CurrentAccount->getValue() < $Offer->getPrice())
            {
//                return false;
                throw new \Exception('Nie masz wystarczającej ilości pieniędzy do kupna tego raportu.');
            }

            if($Company->getRoundOffers()->filter(function(CompanyOffer $OfferReport) use ($Round,$Offer) {return ($OfferReport->getRoundId() == $Round->getId()) && ($OfferReport->getOfferId() == $Offer->getId());})->count() == 0)
            {
                $this->createCompanyOffer($Company,$Offer,$Round);

                $CurrentAccount->setValue($CurrentAccount->getValue()-$Offer->getPrice());
                $AccountChange = $this->getApiCreator()->createAccountChange($Round, $Company, -1 * $Offer->getPrice(), 'Zakup oferty - ' . $Offer->getName());
                $this->getDoctrine()->getManager()->persist($AccountChange);
            }

            $this->getDoctrine()->getManager()->flush();
            $this->getDoctrine()->getConnection()->commit();

            return true;
        }
        catch(\Exception $Exception)
        {
            $this->getDoctrine()->getConnection()->rollback();
            throw new ApiException($Exception->getMessage(), $Exception->getCode());
        }
    }

    /**
     * @param Company $Company
     * @param Offer $Offer
     * @param Round $Round
     * @return CompanyOffer
     */
    private function createCompanyOffer(Company $Company,Offer $Offer,Round $Round)
    {
        $CompanyOffer = new CompanyOffer();
        $CompanyOffer->setCompany($Company);
        $CompanyOffer->setOffer($Offer);
        $CompanyOffer->setRound($Round);

        $this->getDoctrine()->getManager()->persist($CompanyOffer);

        return $CompanyOffer;
    }

    /**
     * @param Company $Company
     * @return array
     */
    private function getOffersOnlyOne(Company $Company)
    {
        $ids = array();
        /** @var CompanyOffer $OfferReport */
        foreach($Company->getRoundOffers() as $OfferReport)
        {
            if($OfferReport->getOffer()->getOnlyOne())
            {
                $ids[] = $OfferReport->getOffer()->getId();
            }
        }
        return $ids;
    }
}
